package com.ihub4us.connector.democonnector;

import static org.junit.Assert.assertEquals;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import com.boomi.connector.api.OperationStatus;
import com.boomi.connector.api.OperationType;
import com.boomi.connector.democonnector.DemoConnector;
import com.boomi.connector.testutil.ConnectorTester;
import com.boomi.connector.testutil.SimpleOperationResult;

public class DemoConnectorTest {

    @Test
    public void testGetOperation() throws Exception
    {
        DemoConnector connector = new DemoConnector();
        ConnectorTester tester = new ConnectorTester(connector);

        // setup the operation context for a GET operation
        Map<String, Object> connProps = new HashMap<String, Object>();
        connProps.putIfAbsent("host", "requestbin.free.beeceptor.com");
        connProps.putIfAbsent("username", "test");
        connProps.putIfAbsent("password", "test");

        Map<String, Object> opProps = new HashMap<String, Object>();

        tester.setOperationContext(OperationType.GET, connProps, opProps, "ORD001", null);

        List<SimpleOperationResult> results = tester.executeGetOperation("ORD001");

        for (SimpleOperationResult result : results) {
            assertEquals("Wrong result", OperationStatus.SUCCESS, result.getStatus());
        }
    }

    @Test
    public void testExecuteOperation() throws Exception
    {
        DemoConnector connector = new DemoConnector();
        ConnectorTester tester = new ConnectorTester(connector);

        // setup the operation context for a GET operation
        Map<String, Object> connProps = new HashMap<String, Object>();
        connProps.putIfAbsent("host", "requestbin.free.beeceptor.com");
        connProps.putIfAbsent("username", "test");
        connProps.putIfAbsent("password", "test");

        Map<String, Object> opProps = new HashMap<String, Object>();
        opProps.putIfAbsent("query", "successes");

        tester.setOperationContext(OperationType.EXECUTE, connProps, opProps, null, null);

        // Create the list of input streams, needed as an input for the Execute operation
        String testinput = "not_needed";
        InputStream targetStream = new ByteArrayInputStream(testinput.getBytes());
        List<InputStream> list = new ArrayList<InputStream>();
        list.add(targetStream);

        List<SimpleOperationResult> results = tester.executeExecuteOperation(list);

        for (SimpleOperationResult result : results) {
            assertEquals("Wrong result", OperationStatus.SUCCESS, result.getStatus());
        }
    }

    @Test
    public void testCreateOperation() throws Exception
    {
        DemoConnector connector = new DemoConnector();
        ConnectorTester tester = new ConnectorTester(connector);

        // setup the operation context for a GET operation
        Map<String, Object> connProps = new HashMap<String, Object>();
        connProps.putIfAbsent("host", "requestbin.free.beeceptor.com");
        connProps.putIfAbsent("username", "test");
        connProps.putIfAbsent("password", "test");

        Map<String, Object> opProps = new HashMap<String, Object>();

        tester.setOperationContext(OperationType.CREATE, connProps, opProps, null, null);

        // Create the list of input streams, needed as an input for the Execute operation
        String testinput = "{\"order_number\":\"ORD001\",\"customer_id\":\"CUST001\",\"customer_name\":\"Alice Smith\",\"order_date\":\"2024-03-01T09:30:00Z\",\"total_amount\":149.99,\"status\":\"Processing\",\"payment_method\":\"Credit Card\",\"shipping_method\":\"Standard\"}";
        InputStream targetStream = new ByteArrayInputStream(testinput.getBytes());
        List<InputStream> list = new ArrayList<InputStream>();
        list.add(targetStream);

        List<SimpleOperationResult> results = tester.executeCreateOperation(list);

        for (SimpleOperationResult result : results) {
            assertEquals("Wrong result", OperationStatus.SUCCESS, result.getStatus());
        }
    }
}
