package com.boomi.connector.democonnector;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.json.JSONObject;

import com.boomi.connector.api.GetRequest;
import com.boomi.connector.api.ObjectIdData;
import com.boomi.connector.api.OperationResponse;
import com.boomi.connector.api.OperationStatus;
import com.boomi.connector.api.PayloadUtil;
import com.boomi.connector.api.ResponseUtil;
import com.boomi.connector.democonnector.client.RESTClient;
import com.boomi.connector.util.BaseGetOperation;
import com.boomi.util.IOUtil;
public class GetOperation extends BaseGetOperation {


   protected GetOperation(DemoConnection connection) {
       super(connection);
   }

   @Override
   public DemoConnection getConnection() {
       return (DemoConnection) super.getConnection();
   }

    @Override
    protected void executeGet(GetRequest request, OperationResponse operationResponse) {
        //Fetch the object ID
        ObjectIdData objectId = request.getObjectId();

        Logger logger 	= operationResponse.getLogger();

        CloseableHttpResponse response = null;
        RESTClient client = null;
        String responseString = null;
        String message = null;

        try {
                        
            String uri = getConnection().getHost() + "/orders/" + objectId.getObjectId();
                  
            // Create the GET request
            HttpUriRequest httpRequest = RequestBuilder.create("GET").setUri(uri).build();

            client = getConnection().getRESTClient();
            // Call the API
            response = client.executeRequest(httpRequest);
            
            // Get the response status code
            int statusCode = response.getStatusLine().getStatusCode();
            
            // Save the response as string, use the utility function we previously defined in the Connection class
            responseString = getConnection().inputStreamToString(response.getEntity().getContent());

            // Instantiate the JsonObject in case we need to parse the JSON response
            JSONObject jsonresponse = new JSONObject(responseString);

            // Not used here, however if the API returns back a status message, you can retrieve it and use it in the
            // connector result
            //message = jsonresponse.getString("some_element");

            if (statusCode >= 200 && statusCode < 300) {
                message = "OK";
                if (!responseString.contains("{}")) {
                    // Return success and continue processing with the API response data
                    operationResponse.addResult(objectId, OperationStatus.SUCCESS, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
                } else {
                    // In case the API returns an empty array
                    logger.log(Level.INFO, "EMPTY RESPONSE: " + responseString);

                    // Return success but stop further processing. Documents stop at this stage and don't continue
                    // further in the process
                    ResponseUtil.addEmptySuccess(operationResponse, objectId,
                        String.valueOf(response.getStatusLine().getStatusCode()));
                }
            } else {
                message = "FAILURE";
                logger.log(Level.SEVERE, "API ERROR: " + responseString);

                // Use APPLICATION_ERROR Operation Status instead of FAILURE to allow setting as 
                // per the operation's "Error Behavior" property
                operationResponse.addResult(objectId, OperationStatus.APPLICATION_ERROR, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
            }
        } catch (Exception e) {
            ResponseUtil.addExceptionFailure(operationResponse, objectId, e);
        } finally {
            IOUtil.closeQuietly(response, client);
        }
    }
}
