package com.boomi.connector.democonnector;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

import com.boomi.connector.api.ObjectData;
import com.boomi.connector.api.OperationResponse;
import com.boomi.connector.api.OperationStatus;
import com.boomi.connector.api.PayloadMetadata;
import com.boomi.connector.api.PayloadUtil;
import com.boomi.connector.api.ResponseUtil;
import com.boomi.connector.api.UpdateRequest;
import com.boomi.connector.democonnector.client.RESTClient;
import com.boomi.connector.util.BaseUpdateOperation;
import com.boomi.util.IOUtil;

import java.util.logging.Logger;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;


public class ExecuteOperation extends BaseUpdateOperation {
   protected ExecuteOperation(DemoConnection connection) {
       super(connection);
   }


   @Override
   public DemoConnection getConnection() {
       return (DemoConnection) super.getConnection();
   }


   @Override
   protected void executeUpdate(UpdateRequest updateRequest, OperationResponse operationResponse) {

        // Get the logger, used for logging purposes
        Logger logger 	= operationResponse.getLogger();

        //PayloadMetadata metadata 	= operationResponse.createMetadata();

        //String host = getContext().getConnectionProperties().getProperty("host");
        //String apikey = getContext().getConnectionProperties().getProperty("apikey");
        //String environmentid = getContext().getConnectionProperties().getProperty("envid");

        // Get the query parameter value defined in the descriptor, as per the user's selection in the operation
        String query = getContext().getOperationProperties().getProperty("query");

        CloseableHttpResponse response = null;
        RESTClient client = null;
        String responseString = null;
        String message = null;

        // Since we are issuing a GET request, we neglect all incoming documents and only get a reference to one
        // So that we don't issue a GET request for each incoming document
        ObjectData input = updateRequest.iterator().next();

        // Get a reference to the dynamic properties defined in the descriptor file
        Map<String, String> dynamicProps	= input.getDynamicProperties();

        // Get the value of the source dynamic document property, as set by the user in the process
        String source = dynamicProps.get("source");

        try {
            // Set the URL            
            String uri = getConnection().getHost() + "/orders";
            
            // Create a GET request, add a source header and the query param as defined in the descriptor
            HttpUriRequest httpRequest = RequestBuilder.create("GET")
                                                        .addHeader("source", source)
                                                        .addParameter("status", query)
                                                        .setUri(uri).build();

            logger.log(Level.INFO, "REQUEST: " + httpRequest.toString());
            client = getConnection().getRESTClient();

            // Call the API
            response = client.executeRequest(httpRequest);

            // Get the response status code
            int statusCode = response.getStatusLine().getStatusCode();
            
            // Save the response as string, use the utility function we previously defined in the Connection class
            responseString = getConnection().inputStreamToString(response.getEntity().getContent());

            // Instantiate the JsonObject in case we need to parse the JSON response
            JSONObject jsonresponse = new JSONObject(responseString);

            // Not used here, however if the API returns back a status message, you can retrieve it and use it in the
            // connector result
            //message = jsonresponse.getString("some_element");

            if (statusCode >= 200 && statusCode < 300) {
                message = "OK";
                if (!responseString.contains("[]")) {
                    // Return success and continue processing with the API response data
                    operationResponse.addResult(input, OperationStatus.SUCCESS, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
                } else {
                    // In case the API returns an empty array
                    logger.log(Level.INFO, "EMPTY RESPONSE: " + responseString);

                    // Return success but stop further processing. Documents stop at this stage and don't continue
                    // further in the process
                    ResponseUtil.addEmptySuccess(operationResponse, input,
                        String.valueOf(response.getStatusLine().getStatusCode()));
                }

            } else {
                message = "FAILURE";
                logger.log(Level.SEVERE, "API ERROR: " + responseString);

                // Use APPLICATION_ERROR Operation Status instead of FAILURE to allow setting as 
                // per the operation's "Error Behavior" property
                operationResponse.addResult(input, OperationStatus.APPLICATION_ERROR, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
            }
        } catch (Exception e) {
            logger.log(Level.SEVERE, "CONNECTOR EXCEPTION: " + e.toString());
            ResponseUtil.addExceptionFailure(operationResponse, input, e);
        } finally {
            IOUtil.closeQuietly(response, client);
            logger.log(Level.INFO, "FINISHED PROCESSING...");
        }
    }
}
