// Copyright (c) 2020 Boomi, Inc.
package com.boomi.connector.democonnector;

import com.boomi.connector.api.BrowseContext;
import com.boomi.connector.api.Browser;
import com.boomi.connector.api.Operation;
import com.boomi.connector.api.OperationContext;
import com.boomi.connector.util.BaseConnector;

public class DemoConnector extends BaseConnector {

    public Browser createBrowser(BrowseContext context) {
        return new DemoBrowser(context);
    }

    @Override
    public Operation createGetOperation(OperationContext context) {
        return new GetOperation(new DemoConnection(context));
    }

    @Override
    public Operation createCreateOperation(OperationContext context)
    {
        return new CreateOperation(new DemoConnection(context));
    }

    @Override
    protected Operation createExecuteOperation(OperationContext context) {
        return new ExecuteOperation(new DemoConnection(context));
    }
}

