package com.boomi.connector.democonnector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;

import com.boomi.connector.api.BrowseContext;
import com.boomi.connector.democonnector.client.RESTClient;
import com.boomi.connector.util.BaseConnection;


public class DemoConnection extends BaseConnection {


    private static final String USERNAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String BASE_HOST_FIELD = "host";

    public DemoConnection(BrowseContext context) {
        super(context);
    }

    /**
     * Fetch the base url field, this is defined in the descriptor. the id should always match to fetch the correct field.
     * @return the baseURL defined by the user
     */
    public String getHost() {
        String host = getContext().getConnectionProperties().getProperty(BASE_HOST_FIELD);

        if (host.startsWith("http")) {
            host = host.replace("https://", "").replace("http://", "");
        }

        host = "https://" + host;

        return host;
    }

    /**
     * transport library, this can be anything you want it to be.
     * @return the restClient
     */
    public RESTClient getRESTClient() {
        return new RESTClient(HttpClientBuilder.create().build(), getHttpContext());
    }

        /**
	 * Utility to convert InputStream to String
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static String inputStreamToString(InputStream is) throws IOException {
		try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is))) {
			return buffer.lines().collect(Collectors.joining("\n"));
		}
	}
    
    private HttpClientContext getHttpContext() {
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setCredentialsProvider(getCredentialsProvider());
        return httpContext;
    }

    private CredentialsProvider getCredentialsProvider() {
        CredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY,
                new UsernamePasswordCredentials(
                        getContext().getConnectionProperties().getProperty(USERNAME_FIELD),
                        getContext().getConnectionProperties().getProperty(PASSWORD_FIELD)));
        return credsProvider;
    }
}
