package com.boomi.connector.democonnector;
import com.boomi.connector.api.BrowseContext;
import com.boomi.connector.api.ConnectorException;
import com.boomi.connector.api.ContentType;
import com.boomi.connector.api.ObjectDefinition;
import com.boomi.connector.api.ObjectDefinitionRole;
import com.boomi.connector.api.ObjectDefinitions;
import com.boomi.connector.api.ObjectType;
import com.boomi.connector.api.ObjectTypes;
import com.boomi.connector.api.OperationType;
import com.boomi.connector.util.BaseBrowser;
import com.boomi.util.ClassUtil;
import com.boomi.util.IOUtil;
import com.boomi.util.StreamUtil;


import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;


public class DemoBrowser extends BaseBrowser {


    private static final String ORDER_SCHEMA = "/order-schema.json";
    private static final String ORDERS_SCHEMA = "/orders-schema.json";
    private static final String UTF8 = "UTF-8";
    private static final String ORDER = "Order";
    private static final String ORDERS = "Orders";

    protected DemoBrowser(BrowseContext context) {
        super(context);
    }

    @Override
    public ObjectTypes getObjectTypes() {
        ObjectTypes types = new ObjectTypes();
        ObjectType ordertype = new ObjectType();
        ordertype.setId(ORDER);
        ordertype.setLabel(ORDER);
        types.getTypes().add(ordertype);

        ObjectType orderstype = new ObjectType();
        orderstype.setId(ORDERS);
        orderstype.setLabel(ORDERS);
        types.getTypes().add(orderstype);

        return types;
    }

    @Override
    public ObjectDefinitions getObjectDefinitions(String objectTypeId, Collection<ObjectDefinitionRole> roles) {
        String jsonSchema = null;
        ObjectDefinitions definitions = new ObjectDefinitions();
        ObjectDefinition objdef = new ObjectDefinition();

        // Get the custom operation schema as per the descriptor operation definition (ex. GET_ALL, INSERT, GET)
        String customOpsType = getContext().getCustomOperationType();

        // Get the operation schema as per the descriptor operation definition (ex. GET, EXECUTE, CREATE) -- NOT USED
        OperationType opsType = getContext().getOperationType();

        switch (customOpsType) {
            case "INSERT":
                jsonSchema = getJsonOrderSchema();
                break;
            case "GET_ALL":
            jsonSchema = getJsonOrdersSchema();
                break;
            case "GET":
                jsonSchema = getJsonOrderSchema();
                break;
            default:
                break;
        }

        if (jsonSchema == null) {
            definitions = this.getUnstructuredSchema(objdef, definitions);
        } else {
            definitions = this.getJsonStructure(jsonSchema, objdef, definitions);
        }
    
        return definitions;
    }

    private static String getJsonOrdersSchema() {
        String schema;
        InputStream is = ClassUtil.getResourceAsStream(ORDERS_SCHEMA);
        try {
            schema = StreamUtil.toString(is, Charset.forName(UTF8));
        } catch (IOException ex) {
            throw new ConnectorException("Error reading schema", ex);
        } finally {
            IOUtil.closeQuietly(is);
        }
        return schema;
    }

    private static String getJsonOrderSchema() {
        String schema;
        InputStream is = ClassUtil.getResourceAsStream(ORDER_SCHEMA);
        try {
            schema = StreamUtil.toString(is, Charset.forName(UTF8));
        } catch (IOException ex) {
            throw new ConnectorException("Error reading schema", ex);
        } finally {
            IOUtil.closeQuietly(is);
        }
        return schema;
    }

    private ObjectDefinitions getUnstructuredSchema(ObjectDefinition objdef, ObjectDefinitions objdefs) {
		objdef.setElementName("");
		objdef.setOutputType(ContentType.BINARY);
		objdef.setInputType(ContentType.NONE);

		objdefs.getDefinitions().add(objdef);
		return objdefs;
	}

    private ObjectDefinitions getJsonStructure(String jsonSchema, ObjectDefinition objdef, ObjectDefinitions objdefs) {
		objdef.setElementName("");
		objdef.setJsonSchema(jsonSchema);
		objdef.setOutputType(ContentType.JSON);
		objdef.setInputType(ContentType.JSON);
		objdefs.getDefinitions().add(objdef);
		return objdefs;
	}
}
