package com.boomi.connector.democonnector;

import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.json.JSONObject;

import com.boomi.connector.api.ObjectData;
import com.boomi.connector.api.OperationResponse;
import com.boomi.connector.api.OperationStatus;
import com.boomi.connector.api.PayloadMetadata;
import com.boomi.connector.api.PayloadUtil;
import com.boomi.connector.api.ResponseUtil;
import com.boomi.connector.api.UpdateRequest;
import com.boomi.connector.democonnector.client.RESTClient;
import com.boomi.connector.democonnector.client.RepeatableInputStreamEntity;
import com.boomi.connector.util.BaseUpdateOperation;
import com.boomi.util.IOUtil;

public class CreateOperation extends BaseUpdateOperation{

    public CreateOperation(DemoConnection connection) {
        super(connection);
    }

    @Override
    public DemoConnection getConnection() {
        return (DemoConnection) super.getConnection();
    }

    @Override
    protected void executeUpdate(UpdateRequest updateRequest, OperationResponse operationResponse) {
        Logger logger 	= operationResponse.getLogger();

        PayloadMetadata metadata 	= operationResponse.createMetadata();
        String responseString = null;
        String message = null;
        Map<String, String> dynamicProps	= null;
        String source = null;
    
        // For all of the incoming documents, perform a POST to create a record 
        RESTClient client = null;
        for (ObjectData data : updateRequest) {
            // Get a reference to the dynamic properties defined in the descriptor file
            dynamicProps	= data.getDynamicProperties();

            // Get the value of the source dynamic document property, as set by the user in the process
            source = dynamicProps.get("source");

            CloseableHttpResponse response = null;
            InputStream dataStream = null;
            try {
                // fetch the document data as a stream
                dataStream = data.getData();

                String uri = getConnection().getHost() + "/orders";
                
                // Create a POST request, add a source header from the document property
                HttpUriRequest request = RequestBuilder.create("POST")
                                                        .addHeader("source", source)
                                                        .setUri(uri).setEntity(
                                        new RepeatableInputStreamEntity(dataStream, data.getDataSize()) {
                                        }).build();
                
                logger.log(Level.INFO, "REQUEST: " + request.toString());

                client = getConnection().getRESTClient();

                // Call the API
                response = client.executeRequest(request);

                InputStream responseStream = response.getEntity().getContent();

                // Save the response as string, use the utility function we previously defined in the Connection class
                responseString = getConnection().inputStreamToString(responseStream);

                // Get the response status code
                int statusCode = response.getStatusLine().getStatusCode();
                
                // Instantiate the JsonObject in case we need to parse the JSON response
                JSONObject jsonresponse = new JSONObject(responseString);

                // The API returns back a status message, retrieve it and use it in the connector result
                message = jsonresponse.getString("message");

                if (statusCode >= 200 && statusCode < 300) {
                    //ResponseUtil.addEmptySuccess(operationResponse, data, String.valueOf(statusCode));
                    operationResponse.addResult(data, OperationStatus.SUCCESS, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
                } else {
                    // Unsuccessful call, return status code of why
                    logger.log(Level.SEVERE, "API ERROR: " + responseString);
                    
                    // Use APPLICATION_ERROR Operation Status instead of FAILURE to allow setting as per the operation's "Error Behavior" property
                    operationResponse.addResult(data, OperationStatus.APPLICATION_ERROR, String.valueOf(statusCode), message, PayloadUtil.toPayload(responseString));
                }
            } catch (Exception e) {
                logger.log(Level.SEVERE, "CONNECTOR EXCEPTION: " + e.toString());
                //Exception occurred, add failure.
                ResponseUtil.addExceptionFailure(operationResponse, data, e);
            } finally {
                IOUtil.closeQuietly(response, dataStream);
                logger.log(Level.INFO, "FINISHED PROCESSING...");
            }
        }
        IOUtil.closeQuietly(client);
    }
    
}
